this.name      = "ups_sun_station_alpha"; 
this.author    = "eric walch"; 
this.copyright = " 2008 eric walch."; 
this.version   = "1.01";

this.playerArrived = false

this.shipSpawned = function()
{
    if(missionVariables.ups_sun == "RESCUE" || missionVariables.ups_sun == "EXPLOSION")
    {
        this.ship.switchAI("sunUpsStationJSAI.plist") // switch AI script on final mission.
    }
    let targetVector = system.sun.position.subtract(this.ship.position).direction()
    let angle = this.ship.heading.angleTo(targetVector) 
    let cross = this.ship.heading.cross(targetVector).direction()
    // align the heading to the targetVector 
    this.ship.setOrientation(this.rotateQ(this.ship.orientation, cross, -angle)) 
    if(this.ship.primaryRole == "ups_dependance") this.buoy = "ups-sun-buoy"
        else this.buoy = "ups-sun-buoy2"
    system.legacy_addShipsAtPrecisely(this.buoy, 1, "abs", this.ship.position.add(this.ship.heading.multiply(10000)))
    delete this.shipSpawned;
}

this.shipDied = function() 
{ 
    if(missionVariables.ups_sun == "RESCUE" || missionVariables.ups_sun == "EXPLOSION")
    {
        this.ship.spawn("sunbase-upscapsule", 15);
        missionVariables.ups_ups_rescue = "YES";
        missionVariables.ups_sun = "EXPLOSION";
        delete this.shipDied;
    }
} 

this.takeHeatDamage = function()
{
     if(!this.playerArrived)
     {
        this.playerArrived = true;
        this.ship.temperature = 1;
        player.consoleMessage("Help us evacuate our last soles.", 6)
     }
     else player.consoleMessage("Hurry up, station core temperature is still rising.", 6)
}

if (0 < oolite.compareVersion("1.72")) 
{ 
    this.rotateQ = function(q, axis, angle) 
    { 
        angle *= 0.5; 
        axis = axis.multiply(Math.sin(angle)); 
        return q.multiply(Math.cos(angle), axis.x, axis.y, axis.z); 
    } 
} 
else 
{ 
    this.rotateQ = function(q, axis, angle) { return q.rotate(axis, angle); } 
}